Option Strict Off
Option Explicit On
Module ElzedBasicDotNet

    Public Declare Function GetTickCount Lib "kernel32" () As Integer

    Public Const kCosmicScope As Byte = 67 'C
    Public Const kGlobalScope As Byte = 71 'G
    Public Const kLocalScope As Byte = 76 'L
    Public Const kDefaultScope As Byte = 68 'D
    Public Const kAnyScope As Byte = 65 'A
    
    Public Const kSimpleComplexity As Byte = 83 'S
    Public Const kComplexComplexity As Byte = 67 'C
    Public Const kDefaultComplexity As Byte = 68 'D

    Public Const kBase2 As Byte = 66 'B
    Public Const kBase8 As Byte = 79 'O
    Public Const kBase10 As Byte = 68 'D
    Public Const kBase12 As Byte = 84 'T
    Public Const kBase16 As Byte = 72 'H

    Public Const kRadixPeriod As Byte = 80 'P
    Public Const kRadixComma As Byte = 67 'C
    
    Public Const kDefaultPrecisionLimit As Integer = 12

    Public Const kQuoteSingle As Byte = 49 '1
    Public Const kQuoteDouble As Byte = 50 '2

    Public Const kAngleRadians As Byte = 82 'R
    Public Const kAngleDegrees As Byte = 68 'D
    Public Const kAngleGrads As Byte = 71 'G
    Public Const kAngleMillicles As Byte = 77 'M

    Public Const kTrueOne As Byte = 67 'C
    Public Const kTrueNegOne As Byte = 78 'N

    Public Const kCoordRect As Byte = 82 'R
    Public Const kCoordPolar As Byte = 80 'P

    Public Const kTypeComp As Byte = 67 'C
    Public Const kTypeNum As Byte = 78 'N
    Public Const kTypeStr As Byte = 83 'S
    Public Const kTypeBool As Byte = 66 'B
    Public Const kTypeNone As Byte = 88 'X

    Public Const kOpPrefix As String = "prefix"
    Public Const kOpInfix As String = "infix"
    Public Const kOpPostfix As String = "postfix"
    Public Const kOpNofix As String = "nofix"

    'Needed to support callback operators under .NET.  See lzLinkCallbackOp below...
    Public Delegate Function ElzedCallbackDelegate(ByVal lLinkID As Integer) As Integer

    'Elzed API declarations...
    Public Declare Function lzAnnotateExp Lib "elzed.dll" Alias "lzAnnotateExpB" (ByVal szExpression As String) As String
    Public Declare Function lzAnnotateParsedExp Lib "elzed.dll" Alias "lzAnnotateParsedExpB" (ByVal hExpression As ULong) As String

    Public Declare Function lzCheckExp Lib "elzed.dll" Alias "lzCheckExpB" (ByVal hExpression As ULong) As String
    Public Declare Function lzClearContext Lib "elzed.dll" () As Byte
    Public Declare Function lzClearErrorCallback Lib "elzed.dll" () As Byte
    Public Declare Sub lzClearLastError Lib "elzed.dll" ()
    Public Declare Function lzCreateBoolVar Lib "elzed.dll" ( ByVal cScope as Byte, ByVal szVariableName As String, ByVal bVariableValue As Boolean ) as ULong
    Public Declare Function lzCreateComplexArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As ULong
    Public Declare Function lzCreateComplexVar Lib "elzed.dll" ( ByVal cScope as Byte, ByVal szVariableName As String, ByVal dRealPart As Double, ByVal dImagPart As Double ) as ULong 
    Public Declare Function lzCreateNumArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzCreateNumVar Lib "elzed.dll" ( ByVal cScope as Byte, ByVal szVariableName As String, ByVal dVariableValue As Double ) as ULong 
    Public Declare Function lzCreatePrivateContext Lib "elzed.dll" (ByVal szContextName As String) As Byte
    Public Declare Function lzCreatePublicContext Lib "elzed.dll" (ByVal szContextName As String) As ULong
    Public Declare Function lzCreateStrArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lStringSize As Integer, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As ULong
    Public Declare Function lzCreateStrVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lStringSize As Integer) As ULong

    Public Declare Function lzDefineError Lib "elzed.dll" (ByVal cScope As Byte, ByVal lErrorID As Integer, ByVal szErrorText As String) As Boolean
    Public Declare Function lzDefineExpOp Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String, ByVal szOperatorType As String, ByVal szReturnType As String, ByVal szParmList As String, ByVal szPrecedenceOp As String, ByVal szExpression As String) As Integer
    Public Declare Function lzDefineExpOpStr Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String, ByVal szExpression As String) As Integer
    Public Declare Sub lzDeleteExp Lib "elzed.dll" (ByVal hExpression As ULong)
    Public Declare Function lzDeleteOp Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String) As Integer
    Public Declare Function lzDeleteVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As Integer
    Public Declare Function lzDestroyPrivateContext Lib "elzed.dll" (ByVal szContextName As String) As Byte
    Public Declare Function lzDestroyPublicContext Lib "elzed.dll" (ByVal szContextName As String) As Byte

    Public Declare Function lzEvalExpHndl Lib "elzed.dll" (ByVal hExpression As ULong) As Byte
    Public Declare Function lzEvalExpHndlToBool Lib "elzed.dll" (ByVal hExpression As ULong) As Byte
    Public Declare Function lzEvalExpHndlToComp Lib "elzed.dll" (ByVal hExpression As ULong, ByRef dpImagPart As Double) As Double
    Public Declare Function lzEvalExpHndlToNum Lib "elzed.dll" (ByVal hExpression As ULong) As Double
    Public Declare Function lzEvalExpHndlToStr Lib "elzed.dll" Alias "lzEvalExpHndlToStrB" (ByVal hExpression As ULong) As String
    Public Declare Function lzEvalExpStr Lib "elzed.dll" (ByVal szExpression As String) As Byte
    Public Declare Function lzEvalExpStrToBool Lib "elzed.dll" (ByVal szExpression As String) As Byte
    Public Declare Function lzEvalExpStrToComp Lib "elzed.dll" (ByVal szExpression As String, ByRef dpImagPart As Double) As Double
    Public Declare Function lzEvalExpStrToNum Lib "elzed.dll" (ByVal szExpression As String) As Double
    Public Declare Function lzEvalExpStrToStr Lib "elzed.dll" Alias "lzEvalExpStrToStrB" (ByVal szExpression As String) As String

    Public Declare Function lzGetAllowComplexResults Lib "elzed.dll" () As Byte
    Public Declare Function lzGetAllowImpliedMult Lib "elzed.dll" () As Byte
    Public Declare Function lzGetAngleUnit Lib "elzed.dll" () As Byte
    Public Declare Function lzGetBooleanTrue Lib "elzed.dll" () As Byte
    Public Declare Function lzGetBoolParm Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As Byte
    Public Declare Function lzGetBoolVarValue Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As Byte
    Public Declare Function lzGetBoolVarValueByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong) As Byte
    Public Declare Function lzGetComplexArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpRealValue As Double, ByRef dpImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzGetComplexArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByRef dpRealValue As Double, ByRef dpImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzGetComplexVarValue Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpRealPart As Double, ByRef dpImagPart As Double) As Byte
    Public Declare Function lzGetComplexVarValueByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByRef dpRealPart As Double, ByRef dpImagPart As Double) As Byte
    Public Declare Function lzGetContextHandle Lib "elzed.dll" (ByVal szContextName As String) As ULong
    Public Declare Function lzGetContextName Lib "elzed.dll" Alias "lzGetContextNameB" (ByVal hExOpUID As ULong) As String
    Public Declare Function lzGetCoordinateFormat Lib "elzed.dll" () As Byte
    Public Declare Function lzGetCurrentContextHandle Lib "elzed.dll" () As ULong
    Public Declare Function lzGetCurrentContextName Lib "elzed.dll" Alias "lzGetCurrentContextNameB" () As String
    Public Declare Function lzGetDefaultVariableScope Lib "elzed.dll" () as Byte
    Public Declare Function lzGetErrorText Lib "elzed.dll" Alias "lzGetErrorTextB" (ByVal lErrorID As Integer) As String
    Public Declare Function lzGetForceComplexResults Lib "elzed.dll" () As Byte
    Public Declare Function lzGetFormattedResultPrecisionLimit Lib "elzed.dll" () As Integer
    Public Declare Function lzGetImagParm Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As Double
    Public Declare Function lzGetInvertArrayIndices Lib "elzed.dll" () As Byte
    Public Declare Function lzGetLastBoolResult Lib "elzed.dll" () As Byte
    Public Declare Function lzGetLastErrorID Lib "elzed.dll" () As Integer
    Public Declare Function lzGetLastErrorText Lib "elzed.dll" Alias "lzGetLastErrorTextB" () As String
    Public Declare Function lzGetLastImagResult Lib "elzed.dll" () As Double
    Public Declare Function lzGetLastNumResult Lib "elzed.dll" () As Double
    Public Declare Function lzGetLastParseIndex Lib "elzed.dll" () As Integer
    Public Declare Function lzGetLastRealResult Lib "elzed.dll" () As Double
    Public Declare Function lzGetLastResultType Lib "elzed.dll" () As Byte
    Public Declare Function lzGetLastStrResult Lib "elzed.dll" Alias "lzGetLastStrResultB" () As String
    Public Declare Function lzGetNumArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Double
    Public Declare Function lzGetNumArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Double
    Public Declare Function lzGetNumParm Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As Double
    Public Declare Function lzGetNumVarValue Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As Double
    Public Declare Function lzGetNumVarValueByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong) As Double
    Public Declare Function lzGetOutputBase Lib "elzed.dll" () As Byte
    Public Declare Function lzGetParmCount Lib "elzed.dll" (ByVal hExOpUID As ULong) As Integer
    Public Declare Function lzGetParmSig Lib "elzed.dll" Alias "lzGetParmSigB" (ByVal hExOpUID As ULong) As String
    Public Declare Function lzGetParmType Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As Byte
    Public Declare Function lzGetQuoteMark Lib "elzed.dll" () As Byte
    Public Declare Function lzGetRadixMark Lib "elzed.dll" () As Byte
    Public Declare Function lzGetRealParm Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As Double
    Public Declare Function lzGetStrArrayElement Lib "elzed.dll" Alias "lzGetStrArrayElementB" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As String
    Public Declare Function lzGetStrArrayElementByHandle Lib "elzed.dll" Alias "lzGetStrArrayElementByHandleB" (ByVal hVariableHandle As ULong, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As String
    Public Declare Function lzGetStrParm Lib "elzed.dll" Alias "lzGetStrParmB" (ByVal hExOpUID As ULong, ByVal lParmIndex As Integer) As String
    Public Declare Function lzGetStrVarValue Lib "elzed.dll" Alias "lzGetStrVarValueB" (ByVal cScope As Byte, ByVal szVariableName As String) As String
    Public Declare Function lzGetStrVarValueByHandle Lib "elzed.dll" Alias "lzGetStrVarValueByHandleB" (ByVal hVariableHandle As ULong) As String
    Public Declare Function lzGetVarHandle Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As ULong
    Public Declare Function lzGetVarType Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As Byte
    Public Declare Function lzGetVarTypeByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong) As Byte

    Public Declare Function lzInitialize Lib "elzed.dll" (ByVal LicenseKey As String) As Byte
    Public Declare Function lzIsArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szArrayName As String) As Byte
    Public Declare Function lzIsArrayHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong) As Byte
    Public Declare Function lzIsOp Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String) As Byte
    Public Declare Function lzIsSymbol Lib "elzed.dll" (ByVal cScope As Byte, ByVal szSymbolName As String) As Byte
    Public Declare Function lzIsVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String) As Byte
    Public Declare Function lzIsVarHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong) As Byte

    Public Declare Function lzLinkCallbackOp Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String, ByVal szOperatorType As String, ByVal szReturnType As String, ByVal szParmList As String, ByVal szPrecedenceOp As String, ByVal pOpFunction As ElzedCallbackDelegate) As Integer
    Public Declare Function lzLinkComplexArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpRealPart As Double, ByRef dpImagPart As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzLinkComplexVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpRealPart As Double, ByRef dpImagPart As Double) As Byte
    Public Declare Function lzLinkNumArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpVariable As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzLinkNumVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByRef dpVariable As Double) As Byte
    Public Declare Function lzLinkStrArray Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal szVariable As String, ByVal lStringSize As Integer, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzLinkStrVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal szVariable As String, ByVal lStringSize As Integer) As Byte
    Public Declare Function lzLockContext Lib "elzed.dll" () As Byte

    Public Declare Function lzParseExp Lib "elzed.dll" (ByVal szExpression As String) As ULong

    Public Declare Function lzReadExpOp Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String, ByVal szOperatorType As String, ByVal szReturnType As String, ByVal szParmList As String, ByVal szPrecedenceOp As String, ByVal szFilePathName As String) As Integer
    Public Declare Function lzReadExpOpStr Lib "elzed.dll" (ByVal cScope As Byte, ByVal szOperatorName As String, ByVal szFilePathName As String) As Integer
    Public Declare Function lzRelease Lib "elzed.dll" () As Byte
    Public Declare Function lzReleaseContext Lib "elzed.dll" () As Byte
    Public Declare Function lzReset Lib "elzed.dll" () As Byte
    Public Declare Function lzResetDefaultContext Lib "elzed.dll" () As Byte
    Public Declare Function lzRevertParsedExp Lib "elzed.dll" Alias "lzRevertParsedExpB" (ByVal hExpression As ULong) As String

    Public Declare Sub lzSetAllowComplexResults Lib "elzed.dll" (ByVal bAllowComplexResults As Boolean)
    Public Declare Sub lzSetAllowImpliedMult Lib "elzed.dll" (ByVal bAllowImpliedMult As Boolean)
    Public Declare Sub lzSetAngleUnit Lib "elzed.dll" (ByVal cAngleUnitCode As Byte)
    Public Declare Sub lzSetBooleanTrue Lib "elzed.dll" (ByVal cBooleanTrueCode As Byte)
    Public Declare Function lzSetBoolResult Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal bBoolResult As Byte) As Integer
    Public Declare Function lzSetBoolVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal bVariableValue As Boolean) As Byte
    Public Declare Function lzSetBoolVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal bVariableValue As Boolean) As Byte
    Public Declare Function lzSetComplexArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dRealValue As Double, ByVal dImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetComplexArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dRealValue As Double, ByVal dImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetComplexVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dRealPart As Double, ByVal dImagPart As Double) As Byte
    Public Declare Function lzSetComplexVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dRealPart As Double, ByVal dImagPart As Double) As Byte
    Public Declare Function lzSetContext Lib "elzed.dll" (ByVal szContextName As String, ByVal bLockContext As Boolean) As Integer
    Public Declare Sub lzSetCoordinateFormat Lib "elzed.dll" (ByVal cCoordinateFormatCode As Byte)
    Public Declare Function lzSetDefaultContext Lib "elzed.dll" (ByVal szContextName As String) As Byte
    Public Declare Sub lzSetDefaultVariableScope Lib "elzed.dll" (ByVal cScope As Byte)
    Public Declare Function lzSetErrorCallback Lib "elzed.dll" (ByVal pErrorCallback As Integer) As Byte
    Public Declare Sub lzSetForceComplexResults Lib "elzed.dll" (ByVal bForceComplexResults As Boolean)
    Public Declare Sub lzSetFormattedResultPrecisionLimit Lib "elzed.dll" (ByVal lLimit As Integer)
    Public Declare Function lzSetImagArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetImagArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dImagValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetImagResult Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal dImagResult As Double) As Integer
    Public Declare Function lzSetImagVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dImagPart As Double) As Byte
    Public Declare Function lzSetImagVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dImagPart As Double) As Byte
    Public Declare Sub lzSetInvertArrayIndices Lib "elzed.dll" (ByVal bInvertArrayIndices As Boolean)
    Public Declare Sub lzSetLastError Lib "elzed.dll" (ByVal lLastError As Integer)
    Public Declare Function lzSetNumArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dVariableValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetNumArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dVariableValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetNumResult Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal dNumResult As Double) As Integer
    Public Declare Function lzSetNumVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dVariableValue As Double) As Byte
    Public Declare Function lzSetNumVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dVariableValue As Double) As Byte
    Public Declare Sub lzSetOutputBase Lib "elzed.dll" (ByVal cOutputBaseCode As Byte)
    Public Declare Sub lzSetQuoteMark Lib "elzed.dll" (ByVal cQuoteMarkCode As Byte)
    Public Declare Sub lzSetRadixMark Lib "elzed.dll" (ByVal cRadixMarkCode As Byte)
    Public Declare Function lzSetRealArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dRealValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetRealArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dRealValue As Double, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetRealResult Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal dRealResult As Double) As Integer
    Public Declare Function lzSetRealVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal dRealPart As Double) As Byte
    Public Declare Function lzSetRealVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal dRealPart As Double) As Byte
    Public Declare Function lzSetStrArrayElement Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal szVariableValue As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetStrArrayElementByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal szVariableValue As String, ByVal lDimensions As Integer, ByVal lDim1 As Integer, ByVal lDim2 As Integer, ByVal lDim3 As Integer, ByVal lDim4 As Integer, ByVal lDim5 As Integer, ByVal lDim6 As Integer) As Byte
    Public Declare Function lzSetStrResult Lib "elzed.dll" (ByVal hExOpUID As ULong, ByVal szStrResult As String) As Integer
    Public Declare Function lzSetStrVar Lib "elzed.dll" (ByVal cScope As Byte, ByVal szVariableName As String, ByVal szVariableValue As String) As Byte
    Public Declare Function lzSetStrVarByHandle Lib "elzed.dll" (ByVal hVariableHandle As ULong, ByVal szVariableValue As String) As Byte
    Public Declare Sub lzShowInfoBox Lib "elzed.dll" ()

    Public Declare Function lzVersion Lib "elzed.dll" () As Double

    'lzLoadElzed & lzUnloadElzed are no-ops in VB, since all Elzed API's are Declared...
    Public Function lzLoadElzed() As Boolean
        lzLoadElzed = True
    End Function
    Public Function lzUnloadElzed() As Boolean
        lzUnloadElzed = True
    End Function
End Module